import pandas as pd
import pickle
from decision_company import read_csv_file, get_min_value, sort_by_values, get_first_n_rows, concatenate_objects, rename_columns, bind_dataframe

# Load the dataset
atp_tennis = read_csv_file("atp_tennis.csv")

concatenated_data = concatenate_objects(
    recent_matches[['Player_1', 'Rank_1']],
    rename_columns(recent_matches[['Player_2', 'Rank_2']], {'Player_2': 'Player_1', 'Rank_2': 'Rank_1'})
)
grouped_data = bind_dataframe(concatenated_data, 'Player_1')
min_values = get_min_value(grouped_data)
sorted_data = sort_by_values(min_values, 'Rank_1')
top_10_ranked_players = get_first_n_rows(sorted_data, 10)

print(top_10_ranked_players)
pickle.dump(top_10_ranked_players,open("./ref_result/top_10_ranked_players.pkl","wb"))